IF EXISTS(SELECT * FROM    sys.objects
			WHERE   object_id = OBJECT_ID(N'[dbo].[P_BUSCA_QT_SOL_PED_CP]')
			AND     type IN (N'P',N'PC'))
        DROP PROCEDURE [DBO].[P_BUSCA_QT_SOL_PED_CP] 
GO

/*
FUNCTION BUSCA A QUANTIDADE GERADA NO PEDIDO APARTIR DO PEDIDO DE SOLICITA??O
EMPRESA: ITEC BRAZIL
DATA INICIO:  23/10/2003  '
DATA TERMINO: 23/10/2003
PROFISSIONAL: Fravi ARAUJO
*/
--EXEC P_BUSCA_QT_SOL_PED_CP 1,'904','4510','0,1,2',570,0,0,0
--Versao 3140
CREATE PROCEDURE [DBO].[P_BUSCA_QT_SOL_PED_CP]
                                         (
                                                 @CD_EMP     INT ,         --CODIGO DA EMPRESA
                                                 @CD_FIL     VARCHAR(MAX), --CODIGO DA FILIAL
                                                 @CD_PED_SOL VARCHAR(MAX), --CODIGO DO PEDIDO DE SOLICITA??O
                                                 @STS_PED    VARCHAR(MAX), --STATUS PEDIDO
                                                 @CD_FORN    INT,
                                                 @CONDICAO   INT,
                                                 @PHLINK     VARCHAR(MAX),
                                                 @COMPRA_OL  INT
                                         ) WITH ENCRYPTION AS
        BEGIN
                SET NOCOUNT ON
                CREATE TABLE #BUSCA_QT_SOL_PED_CP
                             (
                                          CD_EMP           INT         ,
                                          CD_FILIAL        INT         ,
                                          CD_FORN          INT         ,
                                          CD_PED           INT         ,
                                          CD_PED_SOL       INT         ,
                                          CD_PROD          INT         ,
                                          DS_PROD          VARCHAR(300),
                                          DS_UN            VARCHAR(25) ,
                                          QT_IT_SOL        MONEY       ,
                                          QT_IT_AT         MONEY       ,
                                          VLR_PROD         MONEY       ,
                                          VLR_TOT_PROD     MONEY       ,
                                          QT_SLD           MONEY       ,
                                          CD_PROD_FORN     VARCHAR(MAX),
                                          CD_FABRIC        INT         ,
                                          PERC_DESC        MONEY       ,
                                          CD_CTR_ENV       MONEY       ,
                                          CTR_PMC          INT         ,
                                          NM_FABRIC        VARCHAR(400),
                                          CD_BARRA         VARCHAR(50) ,
                                          FLAG_GERAR_CROSS INT         ,
                                          TP_REQ           INT,
                                          QTDE_EMB				MONEY,
										  CONV_UNIDADE			INT,
										  QTDE_UNIDADE			MONEY,
										  QT_SLD_UNIDADE		MONEY,
										  NM_FAMILIA			VARCHAR(400) ,
										  APRES_EMB_CP			MONEY, 
										  APRES_QT_CP			MONEY,
										  FLAG_NAO_CONVERTER_EMBALAGEM	INT,
										  FLAG_TIPO_CONVERSAO		INT)
                CREATE TABLE #RS_PROD_SLD
                             (
                                          CD_EMP      INT  ,
                                          CD_FIL_ENTR INT  ,
                                          CD_PED_SOL  INT  ,
                                          CD_PROD     INT  ,
                                          SLD_PROD    MONEY,
										  QT_SLD_UND	MONEY,
                                          PRIMARY KEY (CD_EMP, CD_PED_SOL, CD_PROD)
                             )
                CREATE TABLE #RS_PROD_FORN
                             (
                                          CD_EMP       INT         ,
                                          CD_PROD      INT         ,
                                          CD_PROD_FORN		VARCHAR(MAX),
										  QT_EMB			MONEY,
										  VLR_PROD_FORN		MONEY,
										  PERC_DESC_FORN	MONEY,
										  APRES_EMB_CP		MONEY,
										  APRES_QT_CP		MONEY,
										  FLAG_NAO_CONVERTER_EMBALAGEM	INT,
										  FLAG_TIPO_CONVERSAO		INT
                                          PRIMARY KEY (CD_EMP, CD_PROD)
                             )
                CREATE TABLE #RS_EST_PED_ELTR_FORN
                             (
                                          CD_EMP              INT     ,
                                          CD_PED_SOL          INT     ,
                                          CD_FIL_ENTR         INT     ,
                                          STS_PED             INT     ,
                                          CD_FORN             INT     ,
                                          CD_PROD             INT     ,
                                          QT_IT_UN            MONEY   ,
                                          DT_PED              DATETIME,
                                          DT_ENTR             DATETIME,
                                          CD_FIL_FAT          INT     ,
                                          VLR_PROD            MONEY   ,
                                          QT_IT_CP            MONEY   ,
                                          TP_REQ              INT     ,
                                          STS_FORN            INT     ,
                                          FLAG_FECHAR         INT     ,
                                          FLAG_PERC_AUMENTO   INT     ,
                                          PERC_AUMENTO        MONEY   ,
                                          FLAG_ESTOQUE_ZERADO INT     ,
                                          HORA_DEMANDA        DATETIME,
                                          FLAG_GERAR_CROSS    INT     ,
										  CONV_UNIDADE		  INT     ,
										  QTDE_UNIDADE			MONEY ,
										  QT_SLD_UNIDADE			MONEY ,
                                          PRIMARY KEY (CD_EMP, CD_PED_SOL, CD_PROD)
                             )
	/* -- LISTA TELA COMPRAS

		0 - SEM VINCULO COM O PHARMALINK
		1 - COM VINCULO COM O PHARMALINK
		2 - IGNORAR VINCULO COM O PHARMALINK
		3 - COM VINCULO COM A ENTIRE
		4 - COM VINCULO COM A ENTIRE E PHARMALINK
		5 - COM VINCULO OL MIX
		6 - COM VINCULO FIDELIZE
		7 - COM WEBOL
	*/

	/* -- LISTA TELA CADASTRO PRODUTOS
	
		0-NORMAL
		1-PHARMALINK
		2-ENTIRE
		3-PHARMALINK E ENTIRE
		4-OL MIX
		5-FIDELIZE
		6-WEBOL
	*/

	--Tipo 2 ignora vinculo...
	IF @PHLINK ='2' 
	BEGIN 
		SET @PHLINK ='1,2,3,4,5,6,7,8,9,0' 
	END

	--Tipo 3 -- ENTIRE
	IF @PHLINK ='3' 
	BEGIN 
		SET @PHLINK ='2' 
	END

	--Tipo 4 -- ENTIRE PHLK
	IF @PHLINK ='4' 
	BEGIN 
		SET @PHLINK ='3' 
	END

	--Tipo 5 -- OL MIX
	IF @PHLINK ='5' 
	BEGIN 
		SET @PHLINK ='4' 
	END

	--Tipo 6 -- FIDELIZE
	IF @PHLINK ='6' 
	BEGIN 
		SET @PHLINK ='5' 
	END
	
	--Tipo 7 -- WEBOL
	IF @PHLINK ='7' 
	BEGIN 
		SET @PHLINK ='6' 
	END
/****************************************************************************************************/
-- Cria tabelas temporarias auxiliares
/****************************************************************************************************/

	IF  OBJECT_ID('TEMPDB.DBO.#RS_FILIAL_PED') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_FILIAL_PED
	END

    CREATE TABLE #RS_FILIAL_PED( CD_FILIAL        INT)

	INSERT INTO #RS_FILIAL_PED
	SELECT DISTINCT ID	   FROM    UFD_PRM_IN_STRING(@CD_FIL);
	-------------------------------------------------------				


	IF  OBJECT_ID('TEMPDB.DBO.#RS_PED_SOL_PED') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_PED_SOL_PED
	END
				
    CREATE TABLE #RS_PED_SOL_PED( CD_PED_SOL        INT)
	INSERT INTO #RS_PED_SOL_PED
	SELECT DISTINCT ID FROM    UFD_PRM_IN_STRING(@CD_PED_SOL); 
	-------------------------------------------------------
	
	IF  OBJECT_ID('TEMPDB.DBO.#RS_PHL_PED') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_PHL_PED
	END		
	CREATE TABLE #RS_PHL_PED( FLAG_PHL INT)

	INSERT INTO #RS_PHL_PED 
	SELECT DISTINCT ID FROM    UFD_PRM_IN_STRING(@PHLINK) 
	-------------------------------------------------------

	IF  OBJECT_ID('TEMPDB.DBO.#RS_STS_PED') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_STS_PED
	END		
	CREATE TABLE #RS_STS_PED( CD_STS INT)

	INSERT INTO #RS_STS_PED 
	SELECT DISTINCT ID FROM    UFD_PRM_IN_STRING(@STS_PED) 

/****************************************************************************************************/


	--------------------------------------------------------------------------------------------
	--ALIMENTANDO A TABELA DE PEDIDOS ELETR?NICOS.
	--------------------------------------------------------------------------------------------
	
	INSERT INTO   #RS_EST_PED_ELTR_FORN
	SELECT EST_PED_ELTR.CD_EMP              ,
		   EST_PED_ELTR.CD_PED_SOL          ,
		   EST_PED_ELTR.CD_FIL_ENTR         ,
		   EST_PED_ELTR.STS_PED             ,
		   0 AS CD_FORN                     ,
		   EST_PED_ELTR_IT.CD_PROD          ,
		   EST_PED_ELTR_IT.QT_IT_UN         ,
		   EST_PED_ELTR.DT_PED              ,
		   EST_PED_ELTR.DT_ENTR             ,
		   EST_PED_ELTR.CD_FIL_FAT          ,
		   EST_PED_ELTR_IT.VLR_PROD,
		   ISNULL(EST_PED_ELTR_IT.QT_IT,0),
		   EST_PED_ELTR.TP_REQ              ,
		   0 AS STS_FORN                    ,
		   EST_PED_ELTR.FLAG_FECHAR         ,
		   EST_PED_ELTR.FLAG_PERC_AUMENTO   ,
		   EST_PED_ELTR.PERC_AUMENTO        ,
		   EST_PED_ELTR.FLAG_ESTOQUE_ZERADO ,
		   EST_PED_ELTR.HORA_DEMANDA        ,
		   ISNULL(EST_PED_ELTR.FLAG_GERAR_CROSS,0),
		   ISNULL(EST_PED_ELTR_IT.UNIDADE,0) CONV_UNIDADE,
		   ISNULL(EST_PED_ELTR_IT.QT_IT_UN,0) QT_IT_UN ,
		   ISNULL(EST_PED_ELTR_IT.QT_IT_UN,0) QT_SLD_UN 
	FROM   
		EST_PED_ELTR
		INNER JOIN EST_PED_ELTR_IT ON     
		EST_PED_ELTR.CD_EMP     = EST_PED_ELTR_IT.CD_EMP AND    
		EST_PED_ELTR.CD_PED_SOL = EST_PED_ELTR_IT.CD_PED_SOL

		INNER JOIN #RS_FILIAL_PED  F ON     
		EST_PED_ELTR.CD_FIL_ENTR = F.CD_FILIAL

		INNER JOIN #RS_PED_SOL_PED P ON     
		EST_PED_ELTR.CD_PED_SOL = P.CD_PED_SOL
		 
		INNER JOIN #RS_STS_PED S ON     
		EST_PED_ELTR.STS_PED = s.CD_STS
   
	WHERE  
		EST_PED_ELTR.CD_EMP            = @CD_EMP
		AND    EST_PED_ELTR.STS_PED    <> 3
		AND    EST_PED_ELTR.FLAG_FECHAR = 0
	
   --------------------------------------------------------------------------------------------
   --ATUALIZANDO OS PEDIDOS QUE POSSU? C?DIGO PARA AS FILIAIS.
   --------------------------------------------------------------------------------------------
	IF @CD_FORN > 0 BEGIN
		UPDATE RS
		SET    CD_FORN = ISNULL(PG_FORN_CD_FIL_FORN.CD_FORN,0)
		FROM   #RS_EST_PED_ELTR_FORN RS
			   INNER JOIN PG_FORN_CD_FIL_FORN
			   ON     RS.CD_EMP            = PG_FORN_CD_FIL_FORN.CD_EMP
			   AND    RS.CD_FIL_ENTR       = PG_FORN_CD_FIL_FORN.CD_FILIAL
		WHERE  PG_FORN_CD_FIL_FORN.CD_EMP  = @CD_EMP
		AND    PG_FORN_CD_FIL_FORN.CD_FORN = @CD_FORN
	END
	
	--------------------------------------------------------------------------------------------
	--ATUALIZANDO DO FORNECEDOR PARA OS PEDIDOS.
	--------------------------------------------------------------------------------------------
	UPDATE RS
	SET    STS_FORN = EST_PED_ELTR_FORN.STS_FORN
	FROM   #RS_EST_PED_ELTR_FORN RS
		   INNER JOIN EST_PED_ELTR_FORN
		   ON     RS.CD_EMP     = EST_PED_ELTR_FORN.CD_EMP
		   AND    RS.CD_PED_SOL = EST_PED_ELTR_FORN.CD_PED_SOL
	
	--------------------------------------------------------------------------------------------
	--VERIFICANDO OS PRODUTOS QUE J? POSSU? PEDIDO DE COMPRA.
	--------------------------------------------------------------------------------------------
	INSERT INTO   #RS_PROD_SLD
	SELECT DISTINCT 
		E.CD_EMP     ,
		E.CD_FIL_ENTR,
		E.CD_PED_SOL ,
		E.CD_PROD    ,
		ISNULL(SUM(E.QT_IT_CP),0),
		ISNULL(SUM(E.QT_IT_CP*E.QT_EMB),0) QT_SLD_UND
	FROM	
		V_EST_PED_ELTR_FORN_EST_PED_CP E
		INNER JOIN #RS_FILIAL_PED  F ON     
		E.CD_FIL_ENTR = F.CD_FILIAL 
		INNER JOIN #RS_PED_SOL_PED P ON     
		E.CD_PED_SOL = P.CD_PED_SOL 
	WHERE           
		E.CD_EMP = @CD_EMP
	GROUP BY        
		E.CD_EMP,E.CD_FIL_ENTR,E.CD_PED_SOL, E.CD_PROD

	------------------------------------------------------------------------------------------------------------------------------------------
	--CAPTURANDO VINCULOS COM O FORNECEDOR OU ALIMENTANDO A TABELA COM OS PRODUTOS DO PEDIDO ELETR?NICO QUANDO N?O INFORMADO O FORNECEDOR.
	------------------------------------------------------------------------------------------------------------------------------------------
	IF @CD_FORN > 0 
		BEGIN
			INSERT INTO   #RS_PROD_FORN
			SELECT 
				F.CD_EMP ,
				F.CD_PROD,
				F.CD_PROD_FORN,
				(F.APRES_EMB_CP * APRES_QT_CP) QT_EMB,
				CASE WHEN ISNULL(VLR_PROD,0) >0 THEN  
				VLR_PROD
				ELSE NULL END VLR_PROD_FORN,
				PERC_DESC PERC_DESC_FORN ,
				F.APRES_EMB_CP,
				F.APRES_QT_CP,
				ISNULL(FF.FLAG_NAO_CONVERTER_EMBALAGEM,0) AS FLAG_NAO_CONVERTER_EMBALAGEM,
				ISNULL(F.FLAG_TIPO_CONVERSAO,0) AS FLAG_TIPO_CONVERSAO
			FROM   
				EST_PROD_FORN F
				INNER JOIN PG_FORN FF ON 
				F.CD_EMP =FF.CD_EMP AND
				F.CD_FORN	 =FF.CD_FORN
				LEFT JOIN EST_PROD_FORN_PERC_DESC D ON
				F.CD_PROD = D.CD_PROD AND
				F.CD_FORN = D.CD_FORN
			WHERE  
				F.CD_FORN        = @CD_FORN
				AND    F.COMPRA_INATIVA = 0
				AND    F.COMPRA_OL      = (
							  CASE
									 WHEN @COMPRA_OL = 2
									 THEN F.COMPRA_OL
									 ELSE @COMPRA_OL
							  END)
							  
							  
		END 
	ELSE 
		BEGIN
			INSERT INTO #RS_PROD_FORN
			SELECT DISTINCT 
				RS.CD_EMP ,
				RS.CD_PROD,
				0 AS CD_PROD_FORN,
				CONVERT(MONEY,REPLACE(EST_PROD.APRES_EMB_CP,',','.')) *  CONVERT(MONEY,REPLACE(EST_PROD.APRES_QT_CP,',','.')) QTDE_EMB,
				NULL VLR_PROD_FORN,
				NULL PERC_DESC_FORN,
				EST_PROD.APRES_EMB_CP,
				EST_PROD.APRES_QT_CP,
				0 AS FLAG_NAO_CONVERTER_EMBALAGEM,
				0 AS FLAG_TIPO_CONVERSAO
			FROM            
				#RS_EST_PED_ELTR_FORN RS
				INNER JOIN EST_PROD ON 
				RS.CD_EMP  = EST_PROD.CD_EMP AND
				RS.CD_PROD = EST_PROD.CD_PROD

	END 
	--------------------------------------------------------------------------------------------
	--CAPTURANDO OUTRAS INFORMA??ES DOS PRODUTOS.
	--------------------------------------------------------------------------------------------
	INSERT INTO   #BUSCA_QT_SOL_PED_CP (CD_EMP,CD_FILIAL,CD_FORN,CD_PED,CD_PED_SOL,CD_PROD,DS_PROD,				
										DS_UN,QT_IT_SOL,QT_IT_AT,VLR_PROD,VLR_TOT_PROD,QT_SLD,CD_PROD_FORN,				
										CD_FABRIC,PERC_DESC,CD_CTR_ENV,CTR_PMC,NM_FABRIC,CD_BARRA,
										FLAG_GERAR_CROSS,TP_REQ,QTDE_EMB,CONV_UNIDADE,QTDE_UNIDADE,QT_SLD_UNIDADE,
										NM_FAMILIA, APRES_EMB_CP, APRES_QT_CP, FLAG_NAO_CONVERTER_EMBALAGEM, FLAG_TIPO_CONVERSAO)

	SELECT DISTINCT 
		RS.CD_EMP                                ,
		RS.CD_FIL_ENTR AS CD_FILIAL              ,
		RS.CD_FORN                               ,
		0 CD_PED                                 ,
		RS.CD_PED_SOL                            ,
		RS.CD_PROD                               ,
		EST_PROD.DS_PROD                         ,
		EST_PROD_UN_MED.DS_UN                    ,
		RS.QT_IT_CP AS QT_IT_SOL                 ,
		0 AS QT_IT_AT                            ,
		RS.VLR_PROD                              ,
		RS.QT_IT_CP * ISNULL(RS_PROD_FORN.VLR_PROD_FORN, RS.VLR_PROD) AS VLR_TOT_PROD,
		RS.QT_IT_CP                              ,
		RS_PROD_FORN.CD_PROD_FORN                ,
		EST_PROD.CD_FABRIC                       ,
		ISNULL(RS_PROD_FORN.PERC_DESC_FORN ,0) PERC_DESC_FORN,
		ISNULL( (SELECT MAX(FENV.CD_CTR_ENV)
				FROM    EST_PED_ELTR_FORN_CTR_ENV FENV
				WHERE   FENV.CD_EMP     = RS.CD_EMP
				AND     FENV.CD_PED_SOL = RS.CD_PED_SOL
				AND     FENV.CD_FORN    = @CD_FORN ),0)      CD_CTR_ENV,
		ISNULL(EST_PROD.CTR_PMC,0) AS CTR_PMC,
		EST_PROD_FABRIC.NM_FABRIC ,
		(SELECT MAX(B.CD_BARRA)
			FROM    EST_PROD_CD_BARRA B
			WHERE   B.CD_EMP  = EST_PROD.CD_EMP
			AND     B.CD_PROD = EST_PROD.CD_PROD AND ISNULL(B.FLAG_PRE_VENCIDOS,0) = 0 ) AS CD_BARRA      ,
		RS.FLAG_GERAR_CROSS,
		RS.TP_REQ, 
		RS_PROD_FORN.QT_EMB,
		RS.CONV_UNIDADE,
		RS.QT_IT_UN,
		RS.QT_IT_UN QT_SLD_UNIDADE,
		FAM.DS_ARV_MERC_FAMILIA,
		RS_PROD_FORN.APRES_EMB_CP, 
		RS_PROD_FORN.APRES_QT_CP,
		RS_PROD_FORN.FLAG_NAO_CONVERTER_EMBALAGEM, 
		RS_PROD_FORN.FLAG_TIPO_CONVERSAO
	FROM        
		#RS_EST_PED_ELTR_FORN RS
		INNER JOIN EST_PROD
		ON              RS.CD_EMP  = EST_PROD.CD_EMP
		AND             RS.CD_PROD = EST_PROD.CD_PROD
		INNER JOIN EST_PROD_UN_MED
		ON              EST_PROD.CD_EMP   = EST_PROD_UN_MED.CD_EMP
		AND             EST_PROD.CD_UN_CP = EST_PROD_UN_MED.CD_CTR_UN
		INNER JOIN EST_PROD_FABRIC
		ON              EST_PROD.CD_FABRIC = EST_PROD_FABRIC.CD_FABRIC
		INNER JOIN #RS_PROD_FORN RS_PROD_FORN ON              
		RS.CD_EMP  = RS_PROD_FORN.CD_EMP AND             
		RS.CD_PROD = RS_PROD_FORN.CD_PROD
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON
		RS.CD_EMP  = ARV.CD_EMP AND             
		RS.CD_PROD = ARV.CD_PROD
		INNER JOIN EST_ARV_MERC_FAMILIA FAM ON
		ARV.CD_EMP  = FAM.CD_EMP AND             
		ARV.CD_ARV_MERC_FAMILIA = FAM.CD_ARV_MERC_FAMILIA
		INNER JOIN #RS_PHL_PED   PH ON              
		EST_PROD.FLAG_COMPRA_PHARMALINK  = PH.FLAG_PHL  
	WHERE
		EST_PROD.CD_EMP=@CD_EMP
	--------------------------------------------------------------------------------------------
	--SOMENTE PRODUTO DE MELHOR CODI??O NO FORNECEDOR POR IMPORTA??O DE ARQUIVOS.
	--------------------------------------------------------------------------------------------
	IF @CONDICAO > 0 
	BEGIN
		DELETE
		FROM   P
		FROM   #BUSCA_QT_SOL_PED_CP P
		WHERE  NOT EXISTS
			   ( SELECT V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_ORDEM
			   FROM    V_EST_PROD_COND_CP_PG_FORN_VIGENTE
			   WHERE   V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_EMP   = P.CD_EMP
			   AND     V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_PROD  = P.CD_PROD
			   AND     V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_EMP   = @CD_EMP
			   AND     V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_FORN  = @CD_FORN
			   AND     V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_ORDEM = @CONDICAO)
	
		UPDATE P
		SET    P.VLR_TOT_PROD = P.QT_IT_SOL * F.VLR_CUSTO,
			   P.PERC_DESC    = F.PERC_DESC
		FROM   #BUSCA_QT_SOL_PED_CP P
			   INNER JOIN V_EST_PROD_COND_CP_PG_FORN_VIGENTE F
			   ON     F.CD_EMP   = P.CD_EMP
			   AND    F.CD_PROD  = P.CD_PROD
			   AND    F.CD_EMP   = @CD_EMP
			   AND    F.CD_FORN  = @CD_FORN
			   AND    F.CD_ORDEM = @CONDICAO
	END
	

	UPDATE P
	SET    
		P.PERC_DESC = IT.PERC_DESC
	FROM   
		#BUSCA_QT_SOL_PED_CP P
		INNER JOIN EST_PED_ELTR F
		ON     F.CD_EMP     = P.CD_EMP
		AND    F.CD_PED_SOL = P.CD_PED_SOL
		AND    F.CD_EMP     = @CD_EMP
		INNER JOIN EST_PED_ELTR_IT IT
		ON     F.CD_EMP     = IT.CD_EMP
		AND    F.CD_PED_SOL = IT.CD_PED_SOL
		AND    P.CD_PROD    = IT.CD_PROD 
	WHERE  
		P.CD_FORN           = @CD_FORN
		AND IT.PERC_DESC > 0
		AND (P.TP_REQ = 0 OR     P.TP_REQ = 1)

		
	--------------------------------------------------------------------------------------------
	--ATUALIZANDO OS PEDIDOS COM A QUANTIDADE J? ATENDIDA.
	--------------------------------------------------------------------------------------------
	UPDATE #BUSCA_QT_SOL_PED_CP
	SET    QT_IT_AT = RS_PROD_SLD.SLD_PROD,
		   QT_SLD   = BUSCA_QT_SOL_PED_CP.QT_IT_SOL - RS_PROD_SLD.SLD_PROD,
		   QT_SLD_UNIDADE = BUSCA_QT_SOL_PED_CP.QT_SLD_UNIDADE  - RS_PROD_SLD.QT_SLD_UND
	FROM   #RS_PROD_SLD RS_PROD_SLD
		   INNER JOIN #BUSCA_QT_SOL_PED_CP BUSCA_QT_SOL_PED_CP
		   ON     RS_PROD_SLD.CD_EMP      = BUSCA_QT_SOL_PED_CP.CD_EMP
		   AND    RS_PROD_SLD.CD_PED_SOL  = BUSCA_QT_SOL_PED_CP.CD_PED_SOL
		   AND    RS_PROD_SLD.CD_FIL_ENTR = BUSCA_QT_SOL_PED_CP.CD_FILIAL
		   AND    RS_PROD_SLD.CD_PROD     = BUSCA_QT_SOL_PED_CP.CD_PROD
	
	--------------------------------------------------------------------------------------------
	--ATUALIZANDO OS PEDIDOS DE COMPRA PARA OS PEDIDOS ELTR?NICOS
	--------------------------------------------------------------------------------------------
	
	UPDATE #BUSCA_QT_SOL_PED_CP
	SET    CD_PED = CD_PED_CP
	FROM   V_EST_PED_ELTR_FORN_EST_PED_CP,
		   #BUSCA_QT_SOL_PED_CP BUSCA_QT_SOL_PED_CP
	WHERE  V_EST_PED_ELTR_FORN_EST_PED_CP.CD_EMP      = BUSCA_QT_SOL_PED_CP.CD_EMP
	AND    V_EST_PED_ELTR_FORN_EST_PED_CP.CD_PED_SOL  = BUSCA_QT_SOL_PED_CP.CD_PED_SOL
	AND    V_EST_PED_ELTR_FORN_EST_PED_CP.CD_FIL_ENTR = BUSCA_QT_SOL_PED_CP.CD_FILIAL
	AND    V_EST_PED_ELTR_FORN_EST_PED_CP.CD_FORN     = BUSCA_QT_SOL_PED_CP.CD_FORN

	/***********************************************************************************************/

	IF  OBJECT_ID('TEMPDB.DBO.#RS_FILIAL_PED') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_FILIAL_PED
	END
	 
	IF  OBJECT_ID('TEMPDB.DBO.#RS_PED_SOL_PED') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_PED_SOL_PED
	END		
	IF  OBJECT_ID('TEMPDB.DBO.#RS_PHL_PED') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_PHL_PED
	END		  
	IF  OBJECT_ID('TEMPDB.DBO.#RS_STS_PED') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_STS_PED
	END		

	/*****************************************************************************************/
	SELECT DISTINCT PED.*,
					PRC_FILIAL.NM_FANT,
					PRC_FILIAL.CONV_PROD_ENT,
					PRC_FILIAL.CGC CNPJ_FILIAL
	FROM            #BUSCA_QT_SOL_PED_CP PED
					INNER JOIN PRC_FILIAL
					ON              PED.CD_EMP    = PRC_FILIAL.CD_EMP
					AND             PED.CD_FILIAL = PRC_FILIAL.CD_FILIAL
	WHERE           PED.QT_SLD                    > 0
	ORDER BY        PED.CD_FILIAL ,
					PED.CD_CTR_ENV,
					PED.CD_PED_SOL,
					PED.DS_PROD 
					
			
			
			

	RETURN
END 
GO